/* global Packages, sc */

let objects = require('common/objects');

let path =  'cdev.broadcast';

// create default project acl without world group
createAcl('cdev.broadcast', false);

// sample: create default project acl with world group
// createAcl('cdev.broadcast', true);

function createAcl(aclName, world) {
  let acl = objects.tryFind('acl:' + 'ACL_' + aclName);
  if (!acl) {
    let aclSettings = {
      name: 'ACL_' + aclName,
      path: path
    };

    if (world) {
      aclSettings.entries = [
        {
          entity: 'group:world',
          access: 'read'
        }
      ];
    }
    
    return objects.create('acl', aclSettings);  
  }
}
